﻿using System;
using System.Collections.Generic;
using System.Text;
using PI.ZB.N1200.ELearning.BL.APIMobile.Model.Data;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    /// <summary>
    /// Bazowa klasa odpowiedzi gdzie odpowiedz jest pusta
    /// </summary>
    public class GResponseData
    {

    }

    /// <summary>
    /// Bazowa klasa dla odpowiedzi ktore zawieraja session_id
    /// </summary>
    public class GResponseData_SessionId : GResponseData
    {
        public string session_id { get; set; }
    }

    /// <summary>
    /// Klasa odpowiedzi dla zapytania userslogin
    /// </summary>
    public class GResponseData_User : GResponseData_SessionId
    {
        public GUsersView User { get; set; }
    }

    /// <summary>
    /// Bazowa klasa dla odpowiedzi zawierajacej count - liczbe elementow w tablicy
    /// </summary>
    public class GResponseData_Count : GResponseData
    {
        public int count { get; set; }
    }

    /// <summary>
    /// Klasa odpowiedzi dla zapytania schoolsindex - lista szkol
    /// </summary>
    public class GResponseData_SchoolsIndex : GResponseData_Count
    {
        public IEnumerable<GSchoolIndex> Schools { get; set; }
    }

    /// <summary>
    /// Klasa odpowiedzi dla zapytania usersindex - lista uczniow
    /// </summary>
    public class GResponseData_UsersIndex : GResponseData_Count
    {
        public IEnumerable<GUsersIndex> Users { get; set; }
    }

    /// <summary>
    /// Klasa odpowiedzi dla zapytania classindex - lista klas
    /// </summary>
    public class GResponseData_ClassIndex : GResponseData_Count
    {
        public IEnumerable<GClassIndex> Class { get; set; }
    }

    /// <summary>
    /// Klassa odpowiedzi dla zapytania compoetencesindex - struktura drzewiasta kompetencji
    /// </summary>
    public class GResponseData_CompetencesIndex : GResponseData_Count
    {
        public IEnumerable<GCompetencesIndex> Competences { get; set; }
        public long suggested_context_id { get; set; }
        public long suggested_course_id { get; set; }
    }

    /// <summary>
    /// Specyficzna klasa odpowiedzi kiedy musimy renderowac do JSONa
    /// nie sama klase GResponse, ale jej wewnetrzny obiekt
    /// Jako InnerData wstawiamy wowczas albo dane szkoly, albo usera, 
    /// albo cos tam jeszcze.
    /// Przyklad uzycia dla schoolsview.
    /// </summary>
    public class GResponseData_InnerData : GResponseData
    {
        public object InnerData { get; set; }
    }

    public class GResponseData_Exercise<T> : GResponseData where T : IExerciseDataStub
    {
        public GExercise Exercise { get; set; }
        public GExerciseMeta ExerciseMeta { get; set; }
        public GExerciseNote ExerciseNote { get; set; }
        public GExerciseOwl ExerciseOwl { get; set; }
        public List<T> ExerciseData { get; set; }
    }

    /// <summary>
    /// Klasa odpowiedzi dla metody competencessave
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public class GResponseData_ExerciseCheck<T> : GResponseData where T : IExerciseDataStub
    {
        public GExerciseOwlSave ExerciseOwl { get; set; }
        public GExerciseMeta ExerciseMeta { get; set; }
        public List<T> ExerciseData { get; set; }
        public List<GExerciseCheck> ExerciseCheck { get; set; }
    }

    /// <summary>
    /// Klasa odpowiedzi dla metody statsview - generuje statystyke do
    /// wyswietlenia na urzadzeniu mobilnym
    /// </summary>
    public class GResponseData_StatsView : GResponseData
    {
        public GResponseData_StatsView()
        {
            Stats = new List<GStatsValue>();
        }

        public List<GStatsValue> Stats { get; set; }
    }

    /// <summary>
    /// Klasa odpowiedzi dla metody certificatesindex - generuje liste certyfikatow dostepnych dla danego ucznia
    /// </summary>
    public class GResponseData_CertificatesIndex : GResponseData_Count
    {
        public GResponseData_CertificatesIndex()
        {
            Certificates = new List<GCertificate>();
        }

        public List<GCertificate> Certificates { get; set; }
    }

    /// <summary>
    /// Klasa odpowiedzi na zadany ranking: rankingview
    /// </summary>
    public class GResponseData_RankingData : GResponseData
    {
        public GResponseData_RankingData()
        {
            Data = new GRankingData();
        }

        public GRankingData Data { get; set; }
    }

    /// <summary>
    /// Klasa odpowiedzi dla statystyk kompetencji głównych oraz składowych
    /// </summary>
    public class GResponseData_StatsCompetenceView : GResponseData
    {
        public GResponseData_StatsCompetenceView()
        {
            Data = new GStatsCompetenceView();
        }

        public GStatsCompetenceView Data { get; set; }
    }

}